//
//  RVUDPNetworkHardwareCommunicator.h
//  CommunicationModule
//
//  Created by Greg Harris on 8/15/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#import "RVNetworkHardwareCommunicator.h"

@class RVGCDAsyncUdpSocket;
@protocol RVUDPNetworkProtocolParser;

typedef NS_ENUM(NSInteger, RVUDPNetworkOptionMode) {
	RVUDPNetworkOptionModeConnect = 1,
	RVUDPNetworkOptionModeListen = 2,
	RVUDPNetworkOptionModeMulticastListen = 3,
	RVUDPNetworkOptionModeBroadcast = 4,
};

@interface RVUDPNetworkHardwareCommunicator : RVNetworkHardwareCommunicator {
	dispatch_queue_t delegateQueue;
	RVGCDAsyncUdpSocket *socket;
	RVUDPNetworkOptionMode socketMode;
	
	IBOutlet NSView *setupView;
	IBOutlet NSPopUpButton *actionPopupButton, *interfacePopupButton;
	IBOutlet NSTextField *addressField, *portField;
	IBOutlet NSButton *goButton;
}

@property (assign) RVUDPNetworkOptionMode socketMode;

- (RVProtocolParser <RVUDPNetworkProtocolParser> *)parser;

- (void) connectToHostAndPort;
- (void) listenOnInterfaceAndPort;
- (void) joinMulticastGroup;
- (void) enableBroadcast;
- (void) close;

- (void) writeData:(NSData *)data withTimeout:(NSTimeInterval)timeout;

- (IBAction) goButtonAction:(id)sender;

@end

@protocol RVUDPNetworkProtocolParser
@optional
- (void) networkHardware:(RVUDPNetworkHardwareCommunicator *)hw readData:(NSData *)data;
- (void) udpDidConnectForNetworkHardware:(RVUDPNetworkHardwareCommunicator *)hw;
- (void) udpDidDisconnectForNetworkHardware:(RVUDPNetworkHardwareCommunicator *)hw;

- (NSUInteger) preferredUDPPortForNetworkHardware:(RVUDPNetworkHardwareCommunicator *)hw;
- (BOOL) allowUDPSocketConnectForNetworkHardware:(RVUDPNetworkHardwareCommunicator *)hw;
- (BOOL) allowUDPSocketListenForNetworkHardware:(RVUDPNetworkHardwareCommunicator *)hw;
- (BOOL) allowUDPSocketMulticastListenForNetworkHardware:(RVUDPNetworkHardwareCommunicator *)hw;
- (BOOL) allowUDPSocketBroadcastForNetworkHardware:(RVUDPNetworkHardwareCommunicator *)hw;
@end

